/* Antarmuka dengan Sensor DHT11 - Basic IoT Kit ESP32
 * Project : Monitoring Suhu dan Kelembaban Udara
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP32 WiFi dan Firebase ESP32
#include <WiFi.h>
#include <FirebaseESP32.h>

// Library OLED Display
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

// Library DHT11
#include <DHT.h>

// Mengatur OLED Display dengan resolusi 128x64
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET    -1
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// PIN DHT Terhubung ke PIN 4 ESP32
#define DHT_PIN  4

// Firebase objek dengan nama fbdo
FirebaseData fbdo;
// DHT objek dengan nama dht
DHT dht(DHT_PIN, DHT11);

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

// Variabel untuk menyimpan data suhu dan kelembaban
float t, h;

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200); 
  dht.begin();

  // Memulai komunikasi dengan OLED Display
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);

  // Membersihkan tampilan display
  display.clearDisplay();
}

void loop() {
  // Membaca suhu dan kelembaban udara
  // Data disimpan pada masing-masing variabel
  t = dht.readTemperature(); // Membaca suhu dalam Celsius
  h = dht.readHumidity();    // Membaca kelembaban Udara
  // Periksa pembacaan jika gagal akan diulangi
  if(isnan(t) || isnan(h)) {
    Serial.println("Tidak dapat membaca sensor DHT11!");
    return;
  }
  // Set nilai menjadi 0 jika data isnan
  if(isnan(t)) t=0;
  if(isnan(h)) h=0;

  // Mencetak data suhu dan kelembaban pada serial monitor
  Serial.println("Temp:" + String(t) + " °C");
  Serial.println("Humd:" + String(h) + " %");
  Serial.println();

  // Mengirim data suhu ke database *user/gauge1
  // Mengirim data kelemababan ke database *user/gauge2
  Firebase.setFloat(fbdo, "/" + user + "/gauge1", t);
  Firebase.setFloat(fbdo, "/" + user + "/gauge2", h);
  
  // Menampilkan data suhu udara pada OLED Display
  display.setTextSize(1);       // Mengatur ukuran teks = 1
  display.setTextColor(WHITE);  // Mengatur teks warna putih
  display.setCursor(0,0);       // Mengatur kursor (x:0, y:0)
  display.print("Suhu: ");      // Mencetak Teks "Suhu:"
  display.setTextSize(2);       // Mengatur ukuran teks = 2
  display.setCursor(0,10);      // Mengatur kursor (x:0, y:10)
  display.print(t);             // Mencetak Nilai suhu
  display.print(" ");           // Mencetak spasi
  display.setTextSize(1);       // Mengatur ukuran teks = 1
  display.cp437(true);          // Char code psge 437
  display.write(167);           // Mencetak char derajat
  display.setTextSize(2);       // Mengatur ukuran teks = 2
  display.print("C");           // Mencetak Teks "Suhu:"
  
  // Menampilkan data Kelembaban uadara pada OLED Display
  display.setTextSize(1);       // Mengatur ukuran teks = 1
  display.setTextColor(WHITE);  // Mengatur teks warna putih
  display.setCursor(0,35);      // Mengatur kursor (x:0, y:0)
  display.print("Kelembaban:"); // Mencetak Teks "LDR Data:"
  display.setTextSize(2);       // Mengatur ukuran teks = 2
  display.setCursor(0,45);      // Mengatur kursor (x:0, y:45)
  display.print(h);             // Mencetak Nilai Sensor LDR
  display.print(" %");          // Mencetak Teks persen
  
  display.display();            // Menampilkan data
  display.clearDisplay();       // Membersihkan tampilan display
}
